#----------------
# Summer School in Fire Dynamics Modelling
# Simo Hostikka, Aalto University
#
# Plot gas emissivity, assuming INCIDENT HEAT FLUX output quantity
#-------------------------

# load module for plotting
import matplotlib.pyplot as plt
# load module for numerics, here used for data read-in
import numpy as np


#Read data
devc_file = 'hottel_array_devc.csv'
data = np.loadtxt(devc_file, delimiter=',', skiprows=2)
R = data[2,1:11];

T = [200,300,400,500,600,700,800,900,1000,2000]
sT4 = np.zeros(len(T))
emissivity = np.zeros(len(T))
for i in range(0,10):
    sT4[i] = 5.67E-11*(T[i]**4)
    emissivity[i] = R[i]/sT4[i]
    print(emissivity[i])

# create a plot of x and y data
fig, ax = plt.subplots()

ax.plot(T,emissivity,'o-',label='E',color='blue')
	
plt.xlabel("T [K]")
plt.ylabel("Emissivity ")
#plt.legend()
plt.show()
fig.clf()
